<?php
/* @var $tender Przetarg */

$name = $tender->kontrahent->nazwa.' - '.$tender->kontrahent->dziedzina->nazwa.' - '.$tender->poziomStr;

$this->breadcrumbs = array(
	'Przetargi'=>array('/teacher/main/tenders'),
	'Przetargi w klasie '.$class->nazwa=>array('/teacher/main/tenders','classId'=>$class->id),
	'Przetargi dla zlecenia '.$name
); ?>

<?php if(Yii::app()->user->hasFlash('error')): ?>
<div class="flash-error">
	<?php echo Yii::app()->user->getFlash('error'); ?>
</div>
<?php endif; ?>

<h1>Przetargi dla zlecenia <?php echo $name ?></h1>

<h6>Informacje o zleceniu:</h6>

<?php
$this->widget('zii.widgets.CDetailView', array(
	'data'=>$tender,
	'attributes'=>array(
		array(
			'label' => '#',
			'value' => $tender->id
		),
		array(
			'label' => 'Dziedzina',
			'value' => $tender->kontrahent->dziedzina->nazwa
		),
		array(
			'label' => 'Poziom',
			'value' => $tender->poziomStr
		),
		array(
			'label' => 'Kontrahent',
			'value' => $tender->kontrahent->nazwa
		),
	),
));

?>
<br />
<h6>Grupy firm, które zgłosiły się do przetargu:</h6>
<br /><hr />
<?php foreach($tender->grupy as $i=>$offer): ?>
		<h6>Grupa nr <?php echo $i+1 ?>:</h6>
		<b>Proponowana cena: </b><?php echo $offer->oferowanaCena ?><br/>
		<b>Uzasadnienie: </b><?php echo $offer->notka ?>
		<?php
			$this->widget('zii.widgets.grid.CGridView', array(
				'id'=>'zlecenie-grid',
				'dataProvider'=>new CArrayDataProvider($offer->firmy),
				'htmlOptions' => array('class' => 'tDefault'),
				'summaryText'=>'',
				'columns'=>array(
					array(
						'name'=>'firma.nazwa',
						'header'=>'Nazwa firmy'
					),
					array(
						'header'=>'Akcje',
						'value'=>'\'<a href="\'.Yii::app()->createUrl(\'/teacher/main/company\',array(\'id\'=>$data->firma->id)).\'" class="buttonS bBlue" target="_blank">Szczegóły</a>\'',
						'type'=>'raw',
						'htmlOptions'=>array('style'=>'width: 90px;')
					)
				),
			));
		?>
		<?php echo CHtml::link('Zaakceptuj tą ofertę',array('/teacher/main/acceptTender','groupId'=>$offer->id,'classId'=>$class->id),array('class'=>'buttonS bGreen','confirm'=>'Czy na pewno chcesz zaakceptować ofertę grupy nr '.($i+1).' z kwotą '.$offer->oferowanaCena.'?')); ?>
		<br /><br />
		<hr />
<?php endforeach; ?>

